/* Copyright (c) 2014, Lytro, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/init.h>
#include <linux/ioport.h>
#include <mach/board.h>
#include <mach/gpio.h>
#include <mach/gpiomux.h>
#include <mach/socinfo.h>

/* TODO: 1. Get right SUSPEND config. 2. Some GPIOs not configured, marked TODO below for them */

/* CONFIG_(FUNCTION)_(OUT/IN)_(PULL) */
#define CONFIG_IO_OH_NP 0
#define CONFIG_IO_OL_NP 1
#define CONFIG_IO_IN_NP 2
#define CONFIG_IO_IN_PU 3
#define CONFIG_IO_IN_PD 4
#define CONFIG_F1_XX_NP 5
#define CONFIG_F2_XX_NP 6
#define CONFIG_F3_XX_NP 7
#define CONFIG_F4_XX_NP 8
#define CONFIG_IO_OH_PU 9
#define CONFIG_IO_XX_NP 10
#define CONFIG_XX_XX_XX CONFIG_IO_IN_PD

static struct gpiomux_setting active_config[] =
{
    {/* 0 - CONFIG_IO_OH_NP */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_OUT_HIGH,
        .drv = GPIOMUX_DRV_8MA,
    },
    {/* 1 - CONFIG_IO_OL_NP */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_OUT_LOW,
        .drv = GPIOMUX_DRV_8MA,
    },
    {/* 2 - CONFIG_IO_IN_NP */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_IN,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
    {/* 3 - CONFIG_IO_IN_PU */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_IN,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_UP,
    },
    {/* 4 - CONFIG_IO_IN_PD */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_IN,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_DOWN,
    },
    {/* 5 - CONFIG_F1_XX_NP */
        .func = GPIOMUX_FUNC_1,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
    {/* 6 - CONFIG_F2_XX_NP */
        .func = GPIOMUX_FUNC_2,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
    {/* 7 - CONFIG_F3_XX_NP */
        .func = GPIOMUX_FUNC_3,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
    {/* 8 - CONFIG_F4_XX_NP */
        .func = GPIOMUX_FUNC_4,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
    {/* 9 - CONFIG_IO_OH_PU */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_OUT_HIGH,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_UP,
    },
    {/* 10 - CONFIG_IO_XX_NP */
        .func = GPIOMUX_FUNC_GPIO,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
};

/* CONFIG_(FUNCTION)_(OUT/IN)_(PULL)_(SUSPEND) */
#define CONFIG_IO_OH_NP_S 0
#define CONFIG_IO_OL_NP_S 1
#define CONFIG_IO_IN_NP_S 2
#define CONFIG_IO_IN_PU_S 3
#define CONFIG_IO_IN_PD_S 4
#define CONFIG_F1_XX_PD_S 5
#define CONFIG_F1_XX_NP_S 6
#define CONFIG_F2_XX_NP_S 7
#define CONFIG_F3_XX_NP_S 8
#define CONFIG_F4_XX_NP_S 9
#define CONFIG_IO_OH_PU_S 10
#define CONFIG_IO_XX_NP_S 11
#define CONFIG_XX_XX_XX_S CONFIG_IO_IN_NP_S

static struct gpiomux_setting suspend_config[] =
{
    {/* 0 - CONFIG_IO_OH_NP_S */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_OUT_HIGH,
        .drv = GPIOMUX_DRV_8MA,
    },
    {/* 1 - CONFIG_IO_OL_NP_S */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_OUT_LOW,
        .drv = GPIOMUX_DRV_8MA,
    },
    {/* 2 - CONFIG_IO_IN_NP_S */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_IN,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
    {/* 3 - CONFIG_IO_IN_PU_S */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_IN,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_UP,
    },
    {/* 4 - CONFIG_IO_IN_PD_S */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_IN,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_DOWN,
    },
    {/* 5 - CONFIG_F1_XX_PD_S */
        .func = GPIOMUX_FUNC_1,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_DOWN,
    },
    {/* 6 - CONFIG_F1_XX_NP_S */
        .func = GPIOMUX_FUNC_1,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
    {/* 7 - CONFIG_F2_XX_NP_S */
        .func = GPIOMUX_FUNC_2,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
    {/* 8 - CONFIG_F3_XX_NP_S */
        .func = GPIOMUX_FUNC_3,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
    {/* 9 - CONFIG_F4_XX_NP_S */
        .func = GPIOMUX_FUNC_4,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
    {/* 10 - CONFIG_IO_OH_PU_S */
        .func = GPIOMUX_FUNC_GPIO,
        .dir = GPIOMUX_OUT_HIGH,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_UP,
    },
    {/* 11 - CONFIG_IO_XX_NP_S */
        .func = GPIOMUX_FUNC_GPIO,
        .drv = GPIOMUX_DRV_8MA,
        .pull = GPIOMUX_PULL_NONE,
    },
};

static struct msm_gpiomux_config configs[] __initdata =
{
    /* DEBUG_UART_TXD */           { .gpio =   0, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F2_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F2_XX_NP_S], }, },
    /* DEBUG_UART_RXD */           { .gpio =   1, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F2_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F2_XX_NP_S], }, },
    /* DEBUG_UART_CTS */           { .gpio =   2, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F2_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F2_XX_NP_S], }, },
    /* DEBUG_UART_RTS */           { .gpio =   3, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F2_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F2_XX_NP_S], }, },

    /* X */                        { .gpio =   4, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =   5, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* TP_I2C_SDA */               { .gpio =   6, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F3_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F3_XX_NP_S], }, },
    /* TP_I2C_SCL */               { .gpio =   7, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F3_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F3_XX_NP_S], }, },

    /* X */                        { .gpio =   8, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =   9, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* I2C_SDA */                  { .gpio =  10, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F3_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F3_XX_NP_S], }, },
    /* I2C_SCL */                  { .gpio =  11, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F3_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F3_XX_NP_S], }, },

    /* DISP1_TEARING */  /* TODO */{ .gpio =  12, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OH_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_NP_S], }, },

    /* X */                        { .gpio =  13, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* LCM_ID */         /* TODO */{ .gpio =  14, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PD], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },

    /* R50_CAM_MCLK */             { .gpio =  15, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_PD_S], }, },

    /* X */                        { .gpio =  16, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  17, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* R50_LENS_MCLK */            { .gpio =  18, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_PD_S], }, },
    /* CCI_I2C_SDA */              { .gpio =  19, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_NP_S], }, },
    /* CCI_I2C_SCL */              { .gpio =  20, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_NP_S], }, },

    /* X */                        { .gpio =  21, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  22, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* SHUTTER_1 - FOCUS */        { .gpio =  23, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PU], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PU_S], }, },
    /* SHUTTER_2 - SNAPSHOT */     { .gpio =  24, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PU], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PU_S], }, },

    /* X */                        { .gpio =  25, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  26, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  27, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  28, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  29, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  30, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  31, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  32, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  33, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  34, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* WCN3680_BT_SSBI */          { .gpio =  35, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* WCN3680_WLAN_D2 */          { .gpio =  36, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* WCN3680_WLAN_D1 */          { .gpio =  37, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* WCN3680_WLAN_D0 */          { .gpio =  38, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* WCN3680_WLAN_CMD */         { .gpio =  39, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* R50_WCN3680_WLAN_CLK */     { .gpio =  40, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },

    /* X */                        { .gpio =  41, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  42, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* WCN3680_BT_CTRL */          { .gpio =  43, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* WCN3680_BT_DATA */          { .gpio =  44, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },

    /* LENS_SPI_MOSI */            { .gpio =  45, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F2_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* LENS_SPI_MISO */            { .gpio =  46, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F2_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* LENS_SPI_CS_N */            { .gpio =  47, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* LENS_SPI_CLK */             { .gpio =  48, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },

    /* X */                        { .gpio =  49, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* SD_CARD_WP_N */             { .gpio =  50, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },

    /* UI_I2C_SDA */               { .gpio =  51, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F4_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F4_XX_NP_S], }, },
    /* UI_I2C_SCL */               { .gpio =  52, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F4_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F4_XX_NP_S], }, },

    /* X */                        { .gpio =  53, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  54, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  55, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  56, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  57, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* CAM_DCDC_EN */              { .gpio =  58, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },
    /* UI_INT */                   { .gpio =  59, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PU], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PU_S], }, },

    /* X */                        { .gpio =  60, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  61, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* SD_CARD_DET_N */            { .gpio =  62, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_NP_S], }, },
    /* WCD9320_RESET_N */          { .gpio =  63, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },
    /* COMPASS_RESET */            { .gpio =  64, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },
    /* ACCEL_INT2_N */             { .gpio =  65, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PD], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },
    /* GYRO_INT */                 { .gpio =  66, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },
    /* COMPASS_INT */              { .gpio =  67, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PD], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },
    /* ALS_INT */                  { .gpio =  68, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },

    /* X */                        { .gpio =  69, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* R50_WCD9320_SLIMBUS_CLK */  { .gpio =  70, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* R50_WCD9320_SLIMBUS_DATA */ { .gpio =  71, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* WCD9320_CODEC_INT1_N */     { .gpio =  72, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PU], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PU_S], }, },

    /* ACCEL_INT1_N */             { .gpio =  73, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PD], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },

    /* X */                        { .gpio =  74, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* LENS_TO_APQ_INT */          { .gpio =  75, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PD], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },

    /* X */                        { .gpio =  76, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* APQ_TO_LENS_INT */          { .gpio =  77, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },

    /* X */                        { .gpio =  78, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  79, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* XFL_FLASH_TRIG */           { .gpio =  80, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },

    /* X */                        { .gpio =  81, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  82, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  83, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  84, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  85, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  86, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* GAUGE_I2C_SDA */            { .gpio =  87, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F3_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F3_XX_NP_S], }, },
    /* GAUGE_I2C_SCL */            { .gpio =  88, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F3_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F3_XX_NP_S], }, },

    /* CAM_SENSOR_PWDN */          { .gpio =  89, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },

    /* X */                        { .gpio =  90, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_XX_NP_S], }, },
    /* X */                        { .gpio =  91, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* LENS_MCU_BOOT_CTRL_1V8 */   { .gpio =  92, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },

    /* X */                        { .gpio =  93, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  94, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* LENS_MCU_RESET_N_1V8 */     { .gpio =  95, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },

    /* X */                        { .gpio =  96, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  97, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  98, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio =  99, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 100, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* BATT_ALARM_OUT */           { .gpio = 101, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PD], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },
    /* TP_INT */                   { .gpio = 102, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PU], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PU_S], }, },
    /* VREG_S3A_1P8 */             { .gpio = 103, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PD], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },

    /* X */                        { .gpio = 104, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 105, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 106, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 107, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 108, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 109, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* VBLK */                     { .gpio = 110, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PD], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },
    /* TP_RST_N */                 { .gpio = 111, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OH_PU], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OH_PU_S], }, },

    /* BOOT_CONFIG0 */             { .gpio = 112, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* BOOT_CONFIG1 */             { .gpio = 113, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* BOOT_CONFIG2 */             { .gpio = 114, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* BOOT_CONFIG3 */             { .gpio = 115, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* BOOT_CONFIG4 */             { .gpio = 116, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },

    /* SDC1_EMMC_1P2_EN */         { .gpio = 117, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PD], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },

    /* BOOT_CONFIG5 */             { .gpio = 118, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },
    /* BOOT_CONFIG6 */             { .gpio = 119, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },

    /* X */                        { .gpio = 120, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 121, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 122, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* DEBUG_UART_CBUS3 */         { .gpio = 123, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PD], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },

    /* X */                        { .gpio = 124, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 125, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* TP_1P8V_ENA */              { .gpio = 126, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OH_PU], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OH_PU_S], }, },

    /* DISP1_RST_N */              { .gpio = 127, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OH_PU], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OH_PU], }, },
    /* EXT_GNSS_LNA_EN */          { .gpio = 128, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },
    /* DISP1_1P8V_ENA */           { .gpio = 129, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OH_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OH_NP_S], }, },

    /* X */                        { .gpio = 130, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 131, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 132, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 133, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 134, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* WGR7640_SSBI1_TX_GPS */     { .gpio = 135, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_F1_XX_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_F1_XX_NP_S], }, },

    /* X */                        { .gpio = 136, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 137, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* HBLK */                     { .gpio = 138, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_IN_PD], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_IN_PD_S], }, },

    /* X */                        { .gpio = 139, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 140, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },

    /* UI_DET */                   { .gpio = 141, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OH_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OH_NP_S], }, },
    /* UART_LSW_ENA */             { .gpio = 142, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_IO_OL_NP], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_IO_OL_NP_S], }, },

    /* X */                        { .gpio = 143, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 144, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
    /* X */                        { .gpio = 145, .settings = { [GPIOMUX_ACTIVE]    = &active_config[CONFIG_XX_XX_XX], [GPIOMUX_SUSPENDED] = &suspend_config[CONFIG_XX_XX_XX_S], }, },
};

void __init apq_8074_evt0_init_gpiomux(void)
{
	int rc;

	rc = msm_gpiomux_init_dt();
	if (rc) {
		pr_err("%s failed %d\n", __func__, rc);
		return;
	}

    msm_gpiomux_install(configs, ARRAY_SIZE(configs));
}
