/* Lytro, Inc. modified this file in 2014. */

#define _LINUX_STRING_H_

#include <linux/compiler.h>	/* for inline */
#include <linux/types.h>	/* for size_t */
#include <linux/stddef.h>	/* for NULL */
#include <linux/linkage.h>
#include <asm/string.h>

extern unsigned long free_mem_ptr;
extern unsigned long free_mem_end_ptr;
extern void error(char *);

#define STATIC static
#define STATIC_RW_DATA	/* non-static please */

#define ARCH_HAS_DECOMP_WDOG

/* Diagnostic functions */
#ifdef DEBUG
#  define Assert(cond,msg) {if(!(cond)) error(msg);}
#  define Trace(x) fprintf x
#  define Tracev(x) {if (verbose) fprintf x ;}
#  define Tracevv(x) {if (verbose>1) fprintf x ;}
#  define Tracec(c,x) {if (verbose && (c)) fprintf x ;}
#  define Tracecv(c,x) {if (verbose>1 && (c)) fprintf x ;}
#else
#  define Assert(cond,msg)
#  define Trace(x)
#  define Tracev(x)
#  define Tracevv(x)
#  define Tracec(c,x)
#  define Tracecv(c,x)
#endif

#ifdef CONFIG_KERNEL_GZIP
#include "../../../../lib/decompress_inflate.c"
#endif

#ifdef CONFIG_KERNEL_LZO
#include "../../../../lib/decompress_unlzo.c"
#endif

#ifdef CONFIG_KERNEL_LZMA
#include "../../../../lib/decompress_unlzma.c"
#endif

#ifdef CONFIG_KERNEL_XZ
#define memmove memmove
#define memcpy memcpy
#include "../../../../lib/decompress_unxz.c"
#endif

#ifdef CONFIG_INST_BOOT
#include "../../../../lib/instboot/inst_boot_log.c"
#else
#define inst_boot_log_init(pbuf, size, count_res, msg)
#define inst_boot_log_msg(msg_pre_tag,msg_tag, msg)
#define inst_boot_log_exit(msg)
#endif

int do_decompress(u8 *input, int len, u8 *output, void (*error)(char *x))
{
    int result = 0;
    inst_boot_log_init((void*)INST_BOOT_LOG_DDR_MEM_BASE, INST_BOOT_LOG_DDR_MEM_SIZE, INST_BOOT_RESOLUTION_ms, "Linux decompress start");
    result = decompress(input, len, NULL, NULL, output, NULL, error);
    inst_boot_log_msg(0, "TS", "Test message from decompressor");
    inst_boot_log_exit("Linux decompress done");
    return result;
}
