LOCAL_PATH := $(call my-dir)
#################################################################################
include $(CLEAR_VARS)
include $(ANDROID_BUILD_TOP)/vendor/lytro/build/snapdragon.mk

LOCAL_MODULE         := libexfat
LOCAL_MODULE_TAGS    := optional eng debug

LOCAL_SRC_FILES      := libexfat/cluster.c \
                        libexfat/io.c \
                        libexfat/log.c \
                        libexfat/lookup.c \
                        libexfat/mount.c \
                        libexfat/node.c \
                        libexfat/time.c \
                        libexfat/utf.c \
                        libexfat/utils.c

LOCAL_CFLAGS         := -Wno-sign-compare               \
                        -Wno-missing-field-initializers \
                        -Wno-unused-parameter           \
                        -D__GLIBC__

ifeq ($(USE_WERROR),1)
LOCAL_CFLAGS += -Werror
endif

LOCAL_EXPORT_C_INCLUDE_DIRS := $(LOCAL_PATH)/libexfat

include $(LYTRO_BUILD_SHARED_LIBRARY)
#################################################################################
include $(CLEAR_VARS)
include $(ANDROID_BUILD_TOP)/vendor/lytro/build/snapdragon.mk

LOCAL_MODULE        := dumpexfat
LOCAL_MODULE_TAGS   := optional eng debug
LOCAL_SRC_FILES     := dump/main.c
LOCAL_CFLAGS        := -Wno-unused-parameter -Wno-format -D__GLIBC__
ifeq ($(USE_WERROR),1)
LOCAL_CFLAGS += -Werror
endif

LOCAL_SHARED_LIBRARIES := libexfat

include $(LYTRO_BUILD_EXECUTABLE)
#################################################################################
include $(CLEAR_VARS)
include $(ANDROID_BUILD_TOP)/vendor/lytro/build/snapdragon.mk

LOCAL_MODULE        := exfatfsck
LOCAL_MODULE_TAGS   := optional eng debug
LOCAL_SRC_FILES     := fsck/main.c
LOCAL_CFLAGS        := -Wno-unused-parameter -D__GLIBC__
ifeq ($(USE_WERROR),1)
LOCAL_CFLAGS += -Werror
endif

LOCAL_SHARED_LIBRARIES := libexfat

include $(LYTRO_BUILD_EXECUTABLE)
#################################################################################
include $(CLEAR_VARS)
include $(ANDROID_BUILD_TOP)/vendor/lytro/build/snapdragon.mk

LOCAL_MODULE        := exfatlabel
LOCAL_MODULE_TAGS   := optional eng debug
LOCAL_SRC_FILES     := label/main.c
LOCAL_CFLAGS        := -D__GLIBC__
ifeq ($(USE_WERROR),1)
LOCAL_CFLAGS += -Werror
endif

LOCAL_SHARED_LIBRARIES := libexfat

include $(LYTRO_BUILD_EXECUTABLE)
#################################################################################
include $(CLEAR_VARS)
include $(ANDROID_BUILD_TOP)/vendor/lytro/build/snapdragon.mk

LOCAL_MODULE        := mkexfatfs
LOCAL_MODULE_TAGS   := optional eng debug

LOCAL_SRC_FILES     := mkfs/cbm.c \
                       mkfs/fat.c \
                       mkfs/main.c \
                       mkfs/mkexfat.c \
                       mkfs/rootdir.c \
                       mkfs/uct.c \
                       mkfs/uctc.c \
                       mkfs/vbr.c

LOCAL_CFLAGS        := -Wno-format  \
                       -Wno-sign-compare \
                       -Wno-missing-field-initializers \
                       -Wno-unused-parameter \
                       -D__GLIBC__

ifeq ($(USE_WERROR),1)
LOCAL_CFLAGS += -Werror
endif

LOCAL_SHARED_LIBRARIES := libexfat

include $(LYTRO_BUILD_EXECUTABLE)
#################################################################################
