/* Copyright (c) 2014, Lytro, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/*
    This file contains the rest of the inst_boot_log implementation that is not shared with decompressor
    and is used by the kernel only
*/

#include "inst_boot_log_local.h"
#include <linux/kernel.h>
#include <linux/io.h>
#include <linux/slab.h>
#include <linux/memblock.h>
#include <linux/vmalloc.h>

int inst_boot_log_init_virtual(void* pbuf, unsigned int size, unsigned int count_res, char* msg)
{
    void *vbuf = ioremap((unsigned long)pbuf, size);
    if(vbuf)
    {
        return inst_boot_log_init(vbuf, size, count_res, msg);
    }
    return IB_FAIL;
}

void inst_boot_log_printf(const char *fmt, ...)
{
    if(inst_boot_log_phdr)
    {
        char buf[512];
        va_list ap;
        va_start(ap, fmt);
        vsnprintf(buf, sizeof(buf) - 1, fmt, ap);
        va_end(ap);
        inst_boot_log_msg(0, "TS", buf);
    }
}

bool inst_boot_log_get_info(void **header_start, void **data_start, size_t *total_size, size_t *available_size)
{
    unsigned long irq_flags;

    if(inst_boot_log_lock_initialized && inst_boot_log_phdr)
    {
        spin_lock_irqsave(&inst_boot_log_lock, irq_flags);
        if(header_start)
        {
            *header_start = (void*)inst_boot_log_phdr;
        }
        if(data_start)
        {
            *data_start = (void*)INST_BOOT_LOG_LOGBUFFER_ADDR(inst_boot_log_phdr->pbufbase);
        }
        if(total_size)
        {
            *total_size = (size_t)(inst_boot_log_phdr->bufsize);
        }
        if(available_size)
        {
            *available_size = (size_t)(inst_boot_log_phdr->logsize);
        }

        spin_unlock_irqrestore(&inst_boot_log_lock, irq_flags);

        return true;
    }
    return false;
}
