/* Copyright (c) 2014, Lytro, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

 #ifndef _LINUX_MASS_STORAGE_VENDOR_SCSI_H
 #define _LINUX_MASS_STORAGE_VENDOR_SCSI_H

 #include <linux/ioctl.h>

#define MASS_STORAGE_VENDOR_SCSI_IOC_MAGIC      'S'

struct mass_storage_vendor_cdb_wrapper {
    int data_dir;
    int data_size;
    unsigned char cdb[16];
 };

 #ifndef _DATA_DIR_ENUM
 #define _DATA_DIR_ENUM
 enum data_direction {
    DATA_DIR_UNKNOWN = 0,
    DATA_DIR_FROM_HOST,
    DATA_DIR_TO_HOST,
    DATA_DIR_NONE
};
 #endif

// The CDB MUST be 16 bytes, by the spec. If it isn't, then all the code that needs it will fail horribly

#define MASS_STORAGE_VENDOR_SCSI_IOC_CHECK_CDB          _IOWR(MASS_STORAGE_VENDOR_SCSI_IOC_MAGIC,  1,   struct mass_storage_vendor_cdb_wrapper)
#define MASS_STORAGE_VENDOR_SCSI_IOC_CDB_CHECK_RESULT   _IO(MASS_STORAGE_VENDOR_SCSI_IOC_MAGIC,    2)
#define MASS_STORAGE_VENDOR_SCSI_IOC_VENDOR_DONE        _IO(MASS_STORAGE_VENDOR_SCSI_IOC_MAGIC,    3)

#endif