/* Copyright (c) 2014, Lytro, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _LINUX_LYTMCU_H
#define _LINUX_LYTMCU_H

#include <linux/types.h>
#include <linux/limits.h>
#include <linux/ioctl.h>

/**
 * DOC: LYTMCU
 *
 */

#define LYTMCU_IOC_BOOTMODE_VALUE_ROM       (0)
#define LYTMCU_IOC_BOOTMODE_VALUE_NORMAL    (1)

struct lytmcu_data
{
    int value;
};

#define LYTMCU_IOC_MAGIC                   'L'
#define LYTMCU_IOC_RESET                   _IOWR(LYTMCU_IOC_MAGIC, 1, struct lytmcu_data)
#define LYTMCU_IOC_POWER                   _IOWR(LYTMCU_IOC_MAGIC, 2, struct lytmcu_data)
#define LYTMCU_IOC_BOOTMODE                _IOWR(LYTMCU_IOC_MAGIC, 3, struct lytmcu_data)

#endif	/* _LINUX_INST_BOOT_H */
