/* Copyright (c) 2014, Lytro, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef INST_BOOT_LOG_H
#define INST_BOOT_LOG_H

#include <linux/inst_boot_log_ddr_info.h>

enum
{
    IB_SUCCESS            =  0,
    IB_FAIL               = -1,
    IB_NOT_ENOUGH_LOG_MEM = -2,
    IB_NULL_PTR           = -3,
    IB_PREV_BL_DIDNT_EXIT = -4
};

#define INST_BOOT_RESOLUTION_ms     1000
#define INST_BOOT_RESOLUTION_100us  10000
#define INST_BOOT_RESOLUTION_us     1000000

#ifdef CONFIG_INST_BOOT
#ifndef STATIC
/* init: */
int inst_boot_log_init(void* pbuf, unsigned int size, unsigned int count_res, char* msg);

/* remap given physical addresses prior to use */
int inst_boot_log_init_virtual(void* pbuf, unsigned int size, unsigned int count_res, char* msg);

/* exit: */
void inst_boot_log_exit(char* msg);

/* log: msg_pre_tag -- refers to the type of log entry -- LK, LINUX, USER, etc.
        msg_tag -- just a tag to specify TS (timestamp), BE ( begininnig) etc.
        msg -- the message itself */
void inst_boot_log_msg(char *msg_pre_tag, char* msg_tag, char* msg);

/* log formatted timestamp */
void inst_boot_log_printf(const char *fmt, ...);

/* get boot log information */
bool inst_boot_log_get_info(void **header_start, void **data_start, size_t *total_size, size_t *available_size);

/* get inst_boot counter's count */
uint64_t inst_boot_get_cnt(void);

/* get frequency of inst_boot counter */
uint32_t inst_boot_get_freq(void);

#endif /* STATIC */

#else
#define inst_boot_log_init(pbuf, size, count_res, msg)
#define inst_boot_log_msg(msg_pre_tag, msg_tag, msg)
#define inst_boot_log_exit(msg)
#define inst_boot_log_init_virtual(pbuf, size, count_res, msg)
#define inst_boot_log_printf(...)
#define inst_boot_log_get_info(...) (false)
#define inst_boot_get_cnt() (0ULL)
#endif /* CONFIG_INST_BOOT */

#endif /* INST_BOOT_LOG_H */
