/* Copyright (c) 2014, Lytro, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _LINUX_INST_BOOT_H
#define _LINUX_INST_BOOT_H

#include <linux/types.h>
#include <linux/limits.h>
#include <linux/ioctl.h>

/**
 * DOC:
 *
 */

#define INST_BOOT_IOC_MAGIC                   'S'
#define INST_BOOT_IOC_MEMORY_TEST             _IOR (INST_BOOT_IOC_MAGIC, 1, int)

struct inst_boot_rwdata
{
    uint32_t addr;
    uint32_t data;
    int32_t  ret;
};
#define INST_BOOT_IOC_MEMORY_RD32             _IOWR(INST_BOOT_IOC_MAGIC, 2, struct inst_boot_rwdata)
#define INST_BOOT_IOC_MEMORY_WR32             _IOWR(INST_BOOT_IOC_MAGIC, 3, struct inst_boot_rwdata)

#define INST_BOOT_ARRAY_SIZE 512
struct inst_boot_rd_char_array
{
    uint32_t addr;
    uint32_t toread;
    uint8_t  data[INST_BOOT_ARRAY_SIZE];
    uint32_t read;
    int32_t  ret;
};
#define INST_BOOT_IOC_MEMORY_RD_CHAR_ARRAY    _IOWR(INST_BOOT_IOC_MAGIC, 4, struct inst_boot_rd_char_array)

struct inst_boot_info
{
    uint32_t baseaddr;
    uint32_t size;
    int32_t  ret;
};
#define INST_BOOT_IOC_MEMORY_INFO             _IOR(INST_BOOT_IOC_MAGIC, 5, struct inst_boot_info)
#endif	/* _LINUX_INST_BOOT_H */
