/* Copyright (c) 2014, Lytro, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _GPIO_WHEELS_H
#define _GPIO_WHEELS_H

struct device;

struct gpio_wheel {
	unsigned int code_clockwise;
	unsigned int code_counter_clockwise;
	int gpio_out;
	int gpio_in;
	int active_low;
	const char *desc;
	unsigned int type;
	int wakeup;
	int debounce_interval;
	bool can_disable;
	unsigned int irq_out;
	unsigned int irq_in;
};

struct gpio_wheels_platform_data {
	struct gpio_wheel *wheels;
	int nwheels;
	unsigned int poll_interval;
	unsigned int rep:1;
	int (*enable)(struct device *dev);
	void (*disable)(struct device *dev);
	const char *name;
};

#endif
