/* Copyright (c) 2014, Lytro, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _LINUX_FD_PORTER_H
#define _LINUX_FD_PORTER_H

#include <linux/limits.h>
#include <linux/ioctl.h>

/**
 * DOC: FD_PORTER_IOC_LYTRO_IMPORT_FD
 *
 * ioctl for transfering file descriptors across PIDs
 * file descriptors can be:
 *    exported  : to generate an opaque handle to transfer to another PID
 *    imported  : to import an opaque handle and convert it to an open 'fd' in this PID
 *    deleted   : to free a shared handle
 */

struct fd_porter_data
{
    int fd;
    void *handle;
};

#define  FD_PORTER_IOC_MAGIC		'F'

#define FD_PORTER_IOC_EXPORT          _IOWR(FD_PORTER_IOC_MAGIC, 1, struct fd_porter_data)

#define FD_PORTER_IOC_IMPORT          _IOWR(FD_PORTER_IOC_MAGIC, 2, struct fd_porter_data)

#define FD_PORTER_IOC_DELETE          _IOWR(FD_PORTER_IOC_MAGIC, 3, struct fd_porter_data)

#endif	/* _LINUX_FD_PORTER_H */
