/*
 * Copyright (C) 2011 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CCVideoLayerImpl_h
#define CCVideoLayerImpl_h

#include "ProgramBinding.h"
#include "ShaderChromium.h"
#include "VideoFrameChromium.h"
#include "VideoLayerChromium.h"
#include "cc/CCLayerImpl.h"

namespace WebCore {

class VideoFrameProvider;

class CCVideoLayerImpl : public CCLayerImpl {
public:
    static PassRefPtr<CCVideoLayerImpl> create(LayerChromium* owner)
    {
        return adoptRef(new CCVideoLayerImpl(owner));
    }
    virtual ~CCVideoLayerImpl();

    typedef ProgramBinding<VertexShaderPosTexTransform, FragmentShaderRGBATexFlipAlpha> RGBAProgram;
    typedef ProgramBinding<VertexShaderPosTexYUVStretch, FragmentShaderYUVVideo> YUVProgram;

    virtual void draw(const IntRect&);

    virtual void dumpLayerProperties(TextStream&, int indent) const;

    void setSkipsDraw(bool skipsDraw) { m_skipsDraw = skipsDraw; }
    void setFrameFormat(VideoFrameChromium::Format format) { m_frameFormat = format; }
    void setTexture(size_t, VideoLayerChromium::Texture);

private:
    explicit CCVideoLayerImpl(LayerChromium*);

    void drawYUV(const YUVProgram*) const;
    void drawRGBA(const RGBAProgram*) const;

    static const float yuv2RGB[9];
    static const float yuvAdjust[3];

    bool m_skipsDraw;
    VideoFrameChromium::Format m_frameFormat;
    VideoLayerChromium::Texture m_textures[3];
};

}

#endif // CCVideoLayerImpl_h
