/*
 * Copyright (C) 2010 Google Inc. All rights reserved.
 * Copyright (C) 2012 Sony Ericsson Mobile Communications AB
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#if ENABLE(WEBGL)

#include "WebKitLoseContext.h"

#include "WebGLRenderingContext.h"

namespace WebCore {

WebKitLoseContext::WebKitLoseContext(WebGLRenderingContext* context)
    : WebGLExtension()
    , m_context(context)
{
}

WebKitLoseContext::~WebKitLoseContext()
{
}

WebGLExtension::ExtensionName WebKitLoseContext::getName() const
{
    return WebKitLoseContextName;
}

PassRefPtr<WebKitLoseContext> WebKitLoseContext::create(WebGLRenderingContext* context)
{
    return adoptRef(new WebKitLoseContext(context));
}

void WebKitLoseContext::loseContext()
{
    if (m_context)
        m_context->forceLostContext(WebGLRenderingContext::SyntheticLostContext);
}

void WebKitLoseContext::restoreContext()
{
    if (m_context)
        m_context->forceRestoreContext();
}

} // namespace WebCore

#endif // ENABLE(WEBGL)
